package gov.va.vamf.scheduling.direct.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import gov.va.vamf.scheduling.direct.eligibilitychecker.ExpressCareTimes;

import javax.xml.bind.annotation.*;
import java.io.Serializable;

@XmlRootElement(name = "appointmentEligibilityAtInstitution", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.DirectScheduling)
public class AppointmentEligibilityAtInstitution implements Serializable {

    private static final long serialVersionUID = 4181252828676038592L;

    @XmlElement
    private Institution institution;

    @XmlElement
    private boolean requestSupported;

    @XmlElement
    private boolean directSchedulingSupported;

    @XmlElement
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private ExpressCareTimes expressTimes;

    @XmlElement
    private String institutionTimezone;

    public Institution getInstitution() {
        return institution;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    public boolean isRequestSupported() {
        return requestSupported;
    }

    public void setRequestSupported(boolean requestSupported) {
        this.requestSupported = requestSupported;
    }

    public boolean isDirectSchedulingSupported() {
        return directSchedulingSupported;
    }

    public void setDirectSchedulingSupported(boolean directSchedulingSupported) {
        this.directSchedulingSupported = directSchedulingSupported;
    }

    public ExpressCareTimes getExpressTimes() {
        return expressTimes;
    }

    public void setExpressTimes(ExpressCareTimes expressTimes) {
        this.expressTimes = expressTimes;
    }

    public String getInstitutionTimezone() {
        return institutionTimezone;
    }

    public void setInstitutionTimezone(String institutionTimezone) {
        this.institutionTimezone = institutionTimezone;
    }
}
